var RSSEntry = function(_rssDesk, _url, _lastFetched = 0, _readLinks = new Set())
{	
	const getUnixTimestamp = function() { return parseInt(new Date().getTime() / 1000) }

	const fetchXML = function() {
		return new Promise(function(resolve, reject ){
			binapp.http('get', [_url]).then(function(xmlText) {
				try {
					let xmlDoc = $.parseXML(xmlText)
					let xml$ = $(xmlDoc)
					
					_lastFetched = getUnixTimestamp()
					
					// remove read links that not exists anymore
					let tmp = new Set()
					let itemsCount = FeedParser.countItem(xml$)
					let newLinks = Array.apply(0, Array(itemsCount)).map(function(_, i){
						return FeedParser.parseItemByIndex(xml$, i).link
					})
					
					_readLinks.forEach(function(link, i){ if (newLinks.indexOf(link) >= 0) tmp.add(link) })
					_readLinks = tmp
					
					Promise.all([
						binapp.data('setitem', [_rssDesk.getDataFilePath(), 'entry', _url, JSON.stringify(toModel())]),
						binapp.data('setitem', [_rssDesk.getDataFilePath(), 'xml', _url, xmlText]),
					]).then(function(){
						resolve([xmlText, xmlDoc, xml$])
					})
				}
				catch (e) {
					reject(e)
				}
			})
		})
	}
	
	const toModel = function() {
		return {url: _url, lastFetched: _lastFetched, readLinks: Array.from(_readLinks) }
	}
	
	return {
		get url() { return _url },
		get lastFetched() { return _lastFetched },
		get model() { return toModel() },
		
		isLinkRead: function(link) {
			return _readLinks.has(link)
		},
		readLink: function (link) {
			binapp.data('setitem', [_rssDesk.getDataFilePath(), 'entry', _url, JSON.stringify(toModel())])
			
			_readLinks.add(link)
		},
		refresh: function(dataFilePath) {
			return fetchXML(dataFilePath)
		},
	}
}